﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:msxsl="urn:schemas-microsoft-com:xslt" exclude-result-prefixes="msxsl">
  
  <xsl:output method="xml" indent="yes"/>
  <xsl:strip-space elements="*"/>
  
  <!-- This universal template only useful when passing through elements unchanged, but in this case all elements are transformed
  <xsl:template match="@* | node()">
    <xsl:copy>
      <xsl:apply-templates select="@* | node()"/>
    </xsl:copy>
  </xsl:template>-->
  
  <!-- DeviceConfiguration -->
  <xsl:template match="DeviceConfiguration">
    <xsl:element name="device_configuration">
      <xsl:attribute name="ship_code">
	      <xsl:value-of select="@ShipID"/>
      </xsl:attribute>
      <xsl:attribute name="creation_date">
	      <xsl:value-of select="@Date"/>
      </xsl:attribute>
      <xsl:attribute name="application_version">
	      <xsl:value-of select="@ApplicationVersion"/>
      </xsl:attribute>
      <xsl:attribute name="database_version">
	      <xsl:value-of select="@DatabaseVersion"/>
      </xsl:attribute>
      <xsl:attribute name="xml_release_id">
	      <xsl:value-of select="@XmlReleaseID"/>
      </xsl:attribute>
      <xsl:attribute name="release_timestamp">
	      <xsl:value-of select="@ReleaseTimestamp"/>
      </xsl:attribute>
      <xsl:apply-templates/>
    </xsl:element>
  </xsl:template>
  
  <!-- Common -->
  <xsl:template match="Comment">
    <xsl:element name="comment">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="PortNo">
    <xsl:element name="port_no">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="DisplayOrder">
    <xsl:element name="display_order">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="SentenceLabel">
    <xsl:element name="sentence_label">
      <xsl:text>Other</xsl:text>
    </xsl:element>
    <xsl:element name="other_sentence_label">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="RecordSize">
    <xsl:element name="record_size">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="BaseDataFieldDef"/>
  <xsl:template match="DataFieldPosition">
    <xsl:choose>
	    <xsl:when test="contains(.,'Serial')"/>
      <xsl:otherwise>
        <xsl:element name="data_field_position">
          <xsl:value-of select="."/>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template match="SCSFile">
    <xsl:element name="scs_file">
      <xsl:attribute name="scs_file_id">
        <xsl:value-of select="@FileID"/>
      </xsl:attribute>
      <xsl:element name="file_name">
        <xsl:value-of select="FileName"/>
      </xsl:element>
      <!-- Since the fields don't exist in SCS 4, will need to populate file_size and sha1_hash after transformation -->
    </xsl:element>
  </xsl:template>
  <xsl:template match="LoggingEnabledFlg">
    <xsl:choose>
      <xsl:when test="../DataFieldType"/> <!-- disregard for Data Field Definitions -->
      <xsl:otherwise>
        <xsl:element name="is_enabled"><!-- new element for v5 message definitions -->
          <xsl:text>1</xsl:text>
        </xsl:element>
        <xsl:element name="is_logged">
          <xsl:text>1</xsl:text><!-- set all to true - the LoggingEnabledFlg on message definitions was never implemented in SCS4 -->
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>



  <!-- SensorDevice -->
  <xsl:template match="SensorDevice">
    <xsl:element name="sensor_interface">
      <xsl:attribute name="sensor_interface_id">
	      <xsl:value-of select="@SensorDeviceID"/>
      </xsl:attribute>
      <xsl:element name="name">
        <xsl:choose>
          <xsl:when test="SensorDeviceType='COM' or SensorDeviceType='Polled COM'">
            <xsl:value-of select="ComPort"/>
          </xsl:when>
          <xsl:when test="SensorDeviceType='Network'">
            <xsl:value-of select="NetworkProtocol"/>-<xsl:value-of select="IPAddress"/>:<xsl:value-of select="PortNo"/>
          </xsl:when>
          <xsl:when test="starts-with(SensorDeviceType,'Derived')">
            <xsl:value-of select="SensorDeviceName"/>
          </xsl:when>
          <xsl:when test="starts-with(SensorDeviceType,'Manual')">
            <xsl:text>Manual:</xsl:text><xsl:value-of select="PortNo"/>
          </xsl:when>
        </xsl:choose>
      </xsl:element>
      <xsl:apply-templates/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="SensorDeviceType">
    <xsl:element name="sensor_interface_type">
      <xsl:choose>
	      <xsl:when test="starts-with(.,'Derived')">Derived</xsl:when>
        <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
  <xsl:template match="SensorDeviceName">
    <xsl:element name="display_name">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="EnabledFlg">
    <xsl:element name="is_enabled">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="DeviceOrder">
    <xsl:element name="display_order">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="ArchivedFlg"/>
  <xsl:template match="IsTemplateFlg"/>
  
  <!-- ComDevice -->
  <xsl:template match="Parity">
    <xsl:element name="parity">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="StopBits">
    <xsl:element name="stop_bits">
      <xsl:value-of select="substring(.,1,1)"/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="ComPort">
    <xsl:element name="com_port">
      <xsl:value-of select="substring(.,4)"/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="BaudRate">
    <xsl:element name="baud_rate">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="DataBits">
    <xsl:element name="data_bits">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  
  <!-- Disregard Update Rate except for Polled COM, and then change it to Polling Rate -->
  <xsl:template match="UpdateRate">
    <xsl:choose>
      <xsl:when test="../SensorDeviceType='Polled COM'">
        <xsl:element name="polling_rate">
          <xsl:value-of select="."/>
        </xsl:element>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  
  <!-- Derived Devices mostly handled by the Derived Message Def templates  -->
  <xsl:template match="OperatorText"/>
  <xsl:template match="AverageType"/>
  <xsl:template match="AverageInterval"/>
  <xsl:template match="Slope"/>
  <xsl:template match="Offset"/>
  
  <!-- ManualDevice handled by the common PortNo template -->
  
  <!-- NetworkDevice -->
  <xsl:template match="NetworkProtocol">
    <xsl:element name="network_protocol">
      <xsl:choose>
	      <xsl:when test=".='UDP Multicast'">UDP</xsl:when>
        <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
  <xsl:template match="IPAddress">
    <xsl:element name="ip_address">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>

  <!-- SimulatedDevice is no more -->
  <xsl:template match="SensorDevice[SensorDeviceType = 'Simulated']"/>
  
  
  <!-- MessageDefinition -->
  <xsl:template match="MessageDefinition">
    <xsl:element name="message_definition">
      <xsl:attribute name="message_definition_id">
	      <xsl:value-of select="@MessageDefinitionID"/>
      </xsl:attribute>
      <xsl:element name="name">
        <xsl:choose>
          <xsl:when test="../SensorDeviceType='COM' or ../SensorDeviceType='Polled COM'">
            <xsl:value-of select="../ComPort"/>
            <xsl:text>-Message</xsl:text>
            <xsl:value-of select="DisplayOrder"/>
          </xsl:when>
          <xsl:when test="../SensorDeviceType='Network'">
            <xsl:value-of select="../NetworkProtocol"/>-<xsl:value-of select="../IPAddress"/>:<xsl:value-of select="../PortNo"/>
            <xsl:text>-Message</xsl:text>
            <xsl:value-of select="DisplayOrder"/>
          </xsl:when>
          <xsl:when test="starts-with(../SensorDeviceType,'Derived')">
            <xsl:value-of select="MessageDefinitionName"/>
          </xsl:when>
          <xsl:when test="starts-with(../SensorDeviceType,'Manual')">
            <xsl:text>Manual:</xsl:text>
            <xsl:value-of select="../PortNo"/>
            <xsl:text>-Message</xsl:text>
            <xsl:value-of select="DisplayOrder"/>
          </xsl:when>
        </xsl:choose>
      </xsl:element>
      <xsl:element name="message_type">
        <xsl:choose>
          <xsl:when test="contains(./MessageType,'Serial')">Fixed</xsl:when>
          <xsl:when test="contains(./MessageType,'NMEA')">NMEA 0183</xsl:when>
          <xsl:when test="contains(./MessageType,'Derived')">Derived</xsl:when>
        </xsl:choose>
      </xsl:element>
      <xsl:element name="display_name">
        <xsl:value-of select="./MessageDefinitionName"/>
      </xsl:element>
      <xsl:choose>
        <xsl:when test="./Delimiter">
          <xsl:choose>
            <xsl:when test="contains(./MessageType,'Serial')"/>
            <!-- drop delimiters if defined for a fixed message -->
            <xsl:otherwise>
                <xsl:element name="field_delimiters">
                  <xsl:for-each select="./Delimiter">
                    <xsl:element name="delimiter_ascii_code">
                      <xsl:value-of select="DelimiterASCIIcode"/>
                    </xsl:element>
                  </xsl:for-each>
                </xsl:element>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
      </xsl:choose>
      <xsl:apply-templates/>
    </xsl:element>
  </xsl:template>
  <!-- MessageType, MessageDefinitionName and Delimiters handled above in MessageDefinition -->
  <xsl:template match="MessageType"/>
  <xsl:template match="MessageDefinitionName"/>
  <xsl:template match="Delimiter"/>
  <xsl:template match="LoggingRate" />
  <xsl:template match="LogSubFolder">
    <xsl:element name="log_folder_path">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="TerminationCharacter">
    <xsl:element name="termination_character">
      <xsl:element name="termination_char_ascii_code">
        <xsl:value-of select="ASCIICode"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <xsl:template match="Timeout"> <!-- no more timeout, add is_relay_via_udp_broadcast here instead -->
    <xsl:element name="is_relay_via_udp_broadcast">
      <xsl:text>0</xsl:text>
    </xsl:element>
  </xsl:template>
  <xsl:template match="SynchCheckFlg"/>
  <xsl:template match="SynchString"/>
  <xsl:template match="SynchStringPosition"/>
  <xsl:template match="FirstMessageDate">
    <xsl:element name="first_message_date">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="LastMessageDate">
    <xsl:element name="last_message_date">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>

  <!-- NMEAMessageDef -->
  <xsl:template match="ExtendLabelFlg">
    <xsl:element name="is_extended_label">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="LabelExtenders">
      <xsl:call-template name="splitExtenders">
        <xsl:with-param name="text" select="."/>
      </xsl:call-template>
  </xsl:template>
  <xsl:template name="splitExtenders">
    <xsl:param name="text"/>
    <xsl:param name="sep" select="','"/>
    <xsl:choose>
      <xsl:when test="contains($text, $sep)">
        <xsl:element name="label_extender">
          <xsl:attribute name="label_extender_id">
            <xsl:text>00000000-0000-0000-0000-000000000000</xsl:text>
          </xsl:attribute>
          <xsl:element name="field_position">
            <xsl:value-of select="substring-before($text, $sep)"/>
          </xsl:element>
          <xsl:element name="expected_value">
            <xsl:text></xsl:text>
          </xsl:element>
        </xsl:element>
        <!-- recursive call -->
        <xsl:call-template name="splitExtenders">
          <xsl:with-param name="text" select="substring-after($text, $sep)" />
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="label_extender">
          <xsl:attribute name="label_extender_id">
            <xsl:text>00000000-0000-0000-0000-000000000000</xsl:text>
          </xsl:attribute>
          <xsl:element name="field_position">
            <xsl:value-of select="$text"/>
          </xsl:element>
          <xsl:element name="expected_value">
            <xsl:text></xsl:text>
          </xsl:element>
        </xsl:element>
    </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- SerialMessageDef handled by the common RecordSize template -->

  <!-- PolledSerialMessageDef -->
  <xsl:template match="CommandPrompt">
    <xsl:element name="polled_command_prompt">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="QueueOrder">
    <xsl:element name="polled_queue_order">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>

  <!-- DerivedMessageDef -->
  

  <!-- DerivedArithmeticMessageDef -->
  <xsl:template match="CalculatedDerivedDataFieldDef[../MessageType = 'Derived Arithmetic']">
    <xsl:element name="calculation_expression">
      <xsl:text>base1</xsl:text>
      <xsl:choose>
        <xsl:when test="../../OperatorText='Plus'">
          <xsl:text> + </xsl:text>
        </xsl:when>
        <xsl:when test="../../OperatorText='Minus'">
          <xsl:text> - </xsl:text>
        </xsl:when>
        <xsl:when test="../../OperatorText='Times'">
          <xsl:text> * </xsl:text>
        </xsl:when>
        <xsl:when test="../../OperatorText='Divided By'">
          <xsl:text> / </xsl:text>
        </xsl:when>
      </xsl:choose>
      <xsl:text>base2</xsl:text>
    </xsl:element>
    <xsl:element name="calc_result_data_field_defs">
      <xsl:apply-templates select="./DataFieldDefinition"/>
    </xsl:element>
    <xsl:element name="calculation_parameters">
      <xsl:element name="calculation_parameter">
        <xsl:attribute name="calculation_parameter_id">
          <xsl:text>00000000-0000-0000-0000-000000000000</xsl:text>
        </xsl:attribute>
        <xsl:element name="parameter_name">
          <xsl:text>base1</xsl:text>
        </xsl:element>
        <xsl:element name="calculation_function_parameter.display_name" />
        <xsl:element name="parameter_data_field_position">
          <xsl:text>2</xsl:text>
        </xsl:element>
        <xsl:element name="is_series">
          <xsl:text>0</xsl:text>
        </xsl:element>
        <xsl:element name="is_compute_on_update">
          <xsl:text>1</xsl:text>
        </xsl:element>
        <xsl:element name="display_order">
          <xsl:text>1</xsl:text>
        </xsl:element>
        <xsl:element name="function_parameter_id" />
        <xsl:element name="data_field_definition">
          <xsl:attribute name="data_field_def_id">
            <xsl:value-of select="../FirstBaseDataFieldDef/DataFieldDefinition/@DataFieldDefID"/>
          </xsl:attribute>
        </xsl:element>
        <xsl:element name="units_type_name">
          <xsl:text>Other</xsl:text>
        </xsl:element>
        <xsl:element name="units_type_id">
          <xsl:text>32</xsl:text>
        </xsl:element>
      </xsl:element>
      <xsl:element name="calculation_parameter">
        <xsl:attribute name="calculation_parameter_id">
          <xsl:text>00000000-0000-0000-0000-000000000000</xsl:text>
        </xsl:attribute>
        <xsl:element name="parameter_name">
          <xsl:text>base2</xsl:text>
        </xsl:element>
        <xsl:element name="calculation_function_parameter.display_name" />
        <xsl:element name="parameter_data_field_position">
          <xsl:text>3</xsl:text>
        </xsl:element>
        <xsl:element name="is_series">
          <xsl:text>0</xsl:text>
        </xsl:element>
        <xsl:element name="is_compute_on_update">
          <xsl:text>1</xsl:text>
        </xsl:element>
        <xsl:element name="display_order">
          <xsl:text>2</xsl:text>
        </xsl:element>
        <xsl:element name="function_parameter_id" />
        <xsl:element name="data_field_definition">
          <xsl:attribute name="data_field_def_id">
            <xsl:value-of select="../SecondBaseDataFieldDef/DataFieldDefinition/@DataFieldDefID"/>
          </xsl:attribute>
        </xsl:element>
        <xsl:element name="units_type_name">
          <xsl:text>Other</xsl:text>
        </xsl:element>
        <xsl:element name="units_type_id">
          <xsl:text>32</xsl:text>
        </xsl:element>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <xsl:template match="FirstBaseDataFieldDef"/>
  <xsl:template match="SecondBaseDataFieldDef"/>

  <!-- DerivedAverageMessageDef -->
  <xsl:template match="CalculatedDerivedDataFieldDef[../MessageType = 'Derived Average']">
    <xsl:element name="calculation_expression">
      <xsl:choose>
        <xsl:when test="../../AverageType='Arithmetic'">
          <xsl:text>Average(base1, </xsl:text>
          <xsl:choose>
            <xsl:when test="../../AverageInterval">
              <xsl:value-of select="../../AverageInterval"/>
              <xsl:text>, s)</xsl:text>
            </xsl:when>
            <xsl:when test="../../NumberOfSamples">
              <xsl:value-of select="../../NumberOfSamples"/>
              <xsl:text>)</xsl:text>
            </xsl:when>
          </xsl:choose>
        </xsl:when>
        <xsl:when test="../../AverageType='Polar'">
          <xsl:text>PolarAverage(base1, </xsl:text>
          <xsl:choose>
            <xsl:when test="../../AverageInterval">
              <xsl:value-of select="../../AverageInterval"/>
              <xsl:text>, s)</xsl:text>
            </xsl:when>
            <xsl:when test="../../NumberOfSamples">
              <xsl:value-of select="../../NumberOfSamples"/>
              <xsl:text>)</xsl:text>
            </xsl:when>
          </xsl:choose>
        </xsl:when>
      </xsl:choose>
    </xsl:element>
    <xsl:element name="calculation_function">
      <xsl:choose>
        <xsl:when test="../../AverageType='Arithmetic'">
          <xsl:choose>
            <xsl:when test="../../AverageInterval">
              <xsl:text>Average (Over Time Span)</xsl:text>
            </xsl:when>
            <xsl:when test="../../NumberOfSamples">
              <xsl:text>Average (Over Sample)</xsl:text>
            </xsl:when>
          </xsl:choose>
        </xsl:when>
        <xsl:when test="../../AverageType='Polar'">
          <xsl:choose>
            <xsl:when test="../../AverageInterval">
              <xsl:text>Polar Average (Over Time Span)</xsl:text>
            </xsl:when>
            <xsl:when test="../../NumberOfSamples">
              <xsl:text>Polar Average (Over Sample)</xsl:text>
            </xsl:when>
          </xsl:choose>
        </xsl:when>
      </xsl:choose>
    </xsl:element>
    <xsl:element name="calc_result_data_field_defs">
      <xsl:apply-templates select="./DataFieldDefinition"/>
    </xsl:element>
    <xsl:element name="calculation_parameters">
      <xsl:element name="calculation_parameter">
        <xsl:attribute name="calculation_parameter_id">
          <xsl:text>00000000-0000-0000-0000-000000000000</xsl:text>
        </xsl:attribute>
        <xsl:element name="parameter_name">
          <xsl:text>series</xsl:text>
        </xsl:element>
        <xsl:element name="calculation_function_parameter.display_name">
          <xsl:text>Series name</xsl:text>
        </xsl:element>
        <xsl:element name="parameter_data_field_position">
          <xsl:text>2</xsl:text>
        </xsl:element>
        <xsl:element name="is_series">
          <xsl:text>1</xsl:text>
        </xsl:element>
        <xsl:element name="is_compute_on_update">
          <xsl:text>1</xsl:text>
        </xsl:element>
        <xsl:element name="display_order">
          <xsl:text>1</xsl:text>
        </xsl:element>
        <xsl:element name="function_parameter_id">
          <xsl:choose>
            <xsl:when test="../../AverageType='Arithmetic'">
              <xsl:choose>
                <xsl:when test="../../AverageInterval">
                  <xsl:text>1</xsl:text>
                </xsl:when>
                <xsl:when test="../../NumberOfSamples">
                  <xsl:text>4</xsl:text>
                </xsl:when>
              </xsl:choose>
            </xsl:when>
            <xsl:when test="../../AverageType='Polar'">
              <xsl:choose>
                <xsl:when test="../../AverageInterval">
                  <xsl:text>6</xsl:text>
                </xsl:when>
                <xsl:when test="../../NumberOfSamples">
                  <xsl:text>9</xsl:text>
                </xsl:when>
              </xsl:choose>
            </xsl:when>
          </xsl:choose>
        </xsl:element>
        <xsl:element name="data_field_definition">
          <xsl:attribute name="data_field_def_id">
            <xsl:value-of select="../BaseDataFieldDef/DataFieldDefinition/@DataFieldDefID"/>
          </xsl:attribute>
        </xsl:element>
        <xsl:element name="units_type_name">
          <xsl:text>Other</xsl:text>
        </xsl:element>
        <xsl:element name="units_type_id">
          <xsl:text>32</xsl:text>
        </xsl:element>
      </xsl:element>
    </xsl:element>
    <xsl:element name="calculation_function_arguments">
      <xsl:choose>
        <xsl:when test="../../AverageType='Arithmetic'">
          <xsl:choose>
            <xsl:when test="../../AverageInterval">       
              <xsl:element name="calculation_function_argument">
                <xsl:attribute name="calculation_function_argument_id">
                  <xsl:text>00000000-0000-0000-0000-000000000000</xsl:text>
                </xsl:attribute>
                <xsl:element name="calculation_function_parameter">
                  <xsl:attribute name="function_parameter_id">
                    <xsl:value-of select="2"/>
                  </xsl:attribute>
                  <xsl:text>timeSpan</xsl:text>
                </xsl:element>
                <xsl:element name="argument_value">
                  <xsl:value-of select="../../AverageInterval"/>
                </xsl:element>
                <xsl:element name="units">
                  <xsl:text>second</xsl:text>
                </xsl:element>
              </xsl:element>
              <xsl:element name="calculation_function_argument">
                <xsl:attribute name="calculation_function_argument_id">
                  <xsl:text>00000000-0000-0000-0000-000000000000</xsl:text>
                </xsl:attribute>
                <xsl:element name="calculation_function_parameter">
                  <xsl:attribute name="function_parameter_id">
                    <xsl:value-of select="3"/>
                  </xsl:attribute>
                  <xsl:text>timeSpanUnits</xsl:text>
                </xsl:element>
                <xsl:element name="argument_value">
                  <xsl:text>s</xsl:text>
                </xsl:element>
                <xsl:element name="units">
                  <xsl:text>None</xsl:text>
                </xsl:element>
              </xsl:element>
            </xsl:when>
            <xsl:when test="../../NumberOfSamples">       
              <xsl:element name="calculation_function_argument">
                <xsl:attribute name="calculation_function_argument_id">
                  <xsl:text>00000000-0000-0000-0000-000000000000</xsl:text>
                </xsl:attribute>
                <xsl:element name="calculation_function_parameter">
                  <xsl:attribute name="function_parameter_id">
                    <xsl:value-of select="5"/>
                  </xsl:attribute>
                  <xsl:text>sampleSize</xsl:text>
                </xsl:element>
                <xsl:element name="argument_value">
                  <xsl:value-of select="../../NumberOfSamples"/>
                </xsl:element>
                <xsl:element name="units">
                  <xsl:text>None</xsl:text>
                </xsl:element>
              </xsl:element>
            </xsl:when>
          </xsl:choose>
        </xsl:when>
        <xsl:when test="../../AverageType='Polar'">
          <xsl:choose>
            <xsl:when test="../../AverageInterval">       
              <xsl:element name="calculation_function_argument">
                <xsl:attribute name="calculation_function_argument_id">
                  <xsl:text>00000000-0000-0000-0000-000000000000</xsl:text>
                </xsl:attribute>
                <xsl:element name="calculation_function_parameter">
                  <xsl:attribute name="function_parameter_id">
                    <xsl:value-of select="7"/>
                  </xsl:attribute>
                  <xsl:text>timeSpan</xsl:text>
                </xsl:element>
                <xsl:element name="argument_value">
                  <xsl:value-of select="../../AverageInterval"/>
                </xsl:element>
                <xsl:element name="units">
                  <xsl:text>second</xsl:text>
                </xsl:element>
              </xsl:element>
              <xsl:element name="calculation_function_argument">
                <xsl:attribute name="calculation_function_argument_id">
                  <xsl:text>00000000-0000-0000-0000-000000000000</xsl:text>
                </xsl:attribute>
                <xsl:element name="calculation_function_parameter">
                  <xsl:attribute name="function_parameter_id">
                    <xsl:value-of select="8"/>
                  </xsl:attribute>
                  <xsl:text>timeSpanUnits</xsl:text>
                </xsl:element>
                <xsl:element name="argument_value">
                  <xsl:text>s</xsl:text>
                </xsl:element>
                <xsl:element name="units">
                  <xsl:text>None</xsl:text>
                </xsl:element>
              </xsl:element>
            </xsl:when>
            <xsl:when test="../../NumberOfSamples">     
              <xsl:element name="calculation_function_argument">
                <xsl:attribute name="calculation_function_argument_id">
                  <xsl:text>00000000-0000-0000-0000-000000000000</xsl:text>
                </xsl:attribute>
                <xsl:element name="calculation_function_parameter">
                  <xsl:attribute name="function_parameter_id">
                    <xsl:value-of select="10"/>
                  </xsl:attribute>
                  <xsl:text>sampleSize</xsl:text>
                </xsl:element>
                <xsl:element name="argument_value">
                  <xsl:value-of select="../../NumberOfSamples"/>
                </xsl:element>
                <xsl:element name="units">
                  <xsl:text>None</xsl:text>
                </xsl:element>
              </xsl:element>
            </xsl:when>
          </xsl:choose>
        </xsl:when>
      </xsl:choose>
    </xsl:element>
  </xsl:template>

  <!-- DerivedLinearEqMessageDef -->
  <xsl:template match="CalculatedDerivedDataFieldDef[../MessageType = 'Derived Linear Equation']">
    <xsl:element name="calculation_expression">
      <xsl:text>LinearEquation(x, </xsl:text>
      <xsl:value-of select="../../Slope"/>
      <xsl:text>, </xsl:text>
      <xsl:value-of select="../../Offset"/>
      <xsl:text>)</xsl:text>
    </xsl:element>
    <xsl:element name="calculation_function">
      <xsl:text>Linear Equation</xsl:text>
    </xsl:element>
    <xsl:element name="calc_result_data_field_defs">
      <xsl:apply-templates select="./DataFieldDefinition"/>
    </xsl:element>
    <xsl:element name="calculation_parameters">
      <xsl:element name="calculation_parameter">
        <xsl:attribute name="calculation_parameter_id">
          <xsl:text>00000000-0000-0000-0000-000000000000</xsl:text>
        </xsl:attribute>
        <xsl:element name="parameter_name">
          <xsl:text>x</xsl:text>
        </xsl:element>
        <xsl:element name="calculation_function_parameter.display_name">
          <xsl:text>Data Field</xsl:text>
        </xsl:element>
        <xsl:element name="parameter_data_field_position">
          <xsl:text>2</xsl:text>
        </xsl:element>
        <xsl:element name="is_series">
          <xsl:text>0</xsl:text>
        </xsl:element>
        <xsl:element name="is_compute_on_update">
          <xsl:text>1</xsl:text>
        </xsl:element>
        <xsl:element name="display_order">
          <xsl:text>1</xsl:text>
        </xsl:element>
        <xsl:element name="function_parameter_id">
          <xsl:text>76</xsl:text>
        </xsl:element>
        <xsl:element name="data_field_definition">
          <xsl:attribute name="data_field_def_id">
            <xsl:value-of select="../BaseDataFieldDef/DataFieldDefinition/@DataFieldDefID"/>
          </xsl:attribute>
        </xsl:element>
        <xsl:element name="units_type_name">
          <xsl:text>Other</xsl:text>
        </xsl:element>
        <xsl:element name="units_type_id">
          <xsl:text>32</xsl:text>
        </xsl:element>
      </xsl:element>
    </xsl:element>
    <xsl:element name="calculation_function_arguments">
      <xsl:element name="calculation_function_argument">
        <xsl:attribute name="calculation_function_argument_id">
          <xsl:text>00000000-0000-0000-0000-000000000000</xsl:text>
        </xsl:attribute>
        <xsl:element name="calculation_function_parameter">
          <xsl:attribute name="function_parameter_id">
            <xsl:value-of select="77"/>
          </xsl:attribute>
          <xsl:text>m</xsl:text>
        </xsl:element>
        <xsl:element name="argument_value">
          <xsl:value-of select="../../Slope"/>
        </xsl:element>
        <xsl:element name="units">
          <xsl:text>None</xsl:text>
        </xsl:element>
      </xsl:element>
      <xsl:element name="calculation_function_argument">
        <xsl:attribute name="calculation_function_argument_id">
          <xsl:text>00000000-0000-0000-0000-000000000000</xsl:text>
        </xsl:attribute>
        <xsl:element name="calculation_function_parameter">
          <xsl:attribute name="function_parameter_id">
            <xsl:value-of select="78"/>
          </xsl:attribute>
          <xsl:text>b</xsl:text>
        </xsl:element>
        <xsl:element name="argument_value">
          <xsl:value-of select="../../Offset"/>
        </xsl:element>
        <xsl:element name="units">
          <xsl:text>None</xsl:text>
        </xsl:element>
      </xsl:element>
    </xsl:element>
  </xsl:template>


  <!-- DerivedTrueWindMessageDef -->
  <xsl:template match="CalculatedTWDirDerivedDataFieldDef">
    <xsl:element name="calculation_expression">
      <xsl:text>TrueWind(sog, cog, heading, relativeWindSpeed, relativeWindDirection)</xsl:text>
    </xsl:element>
    <xsl:element name="calculation_function">
      <xsl:text>True Wind Speed and Direction</xsl:text>
    </xsl:element>
    <xsl:element name="calc_result_data_field_defs">
      <xsl:apply-templates select="../CalculatedTWSpeedDerivedDataFieldDef/DataFieldDefinition"/>
      <xsl:apply-templates select="./DataFieldDefinition"/>
    </xsl:element>
    <xsl:element name="calculation_parameters">
      <xsl:element name="calculation_parameter">
        <xsl:attribute name="calculation_parameter_id">
          <xsl:text>00000000-0000-0000-0000-000000000000</xsl:text>
        </xsl:attribute>
        <xsl:element name="parameter_name">
          <xsl:text>relativeWindSpeed</xsl:text>
        </xsl:element>
        <xsl:element name="calculation_function_parameter.display_name">
          <xsl:text>Relative Wind Speed</xsl:text>
        </xsl:element>
        <xsl:element name="parameter_data_field_position">
          <xsl:text>4</xsl:text>
        </xsl:element>
        <xsl:element name="is_series">
          <xsl:text>0</xsl:text>
        </xsl:element>
        <xsl:element name="is_compute_on_update">
          <xsl:text>1</xsl:text>
        </xsl:element>
        <xsl:element name="display_order">
          <xsl:text>1</xsl:text>
        </xsl:element>
        <xsl:element name="function_parameter_id">
          <xsl:text>14</xsl:text>
        </xsl:element>
        <xsl:element name="data_field_definition">
          <xsl:attribute name="data_field_def_id">
            <xsl:value-of select="../RWSpeedBaseDataFieldDef/DataFieldDefinition/@DataFieldDefID"/>
          </xsl:attribute>
        </xsl:element>
        <xsl:element name="units_type_name">
          <xsl:text>Other</xsl:text>
        </xsl:element>
        <xsl:element name="units_type_id">
          <xsl:text>32</xsl:text>
        </xsl:element>
      </xsl:element>
      <xsl:element name="calculation_parameter">
        <xsl:attribute name="calculation_parameter_id">
          <xsl:text>00000000-0000-0000-0000-000000000000</xsl:text>
        </xsl:attribute>
        <xsl:element name="parameter_name">
          <xsl:text>relativeWindDirection</xsl:text>
        </xsl:element>
        <xsl:element name="calculation_function_parameter.display_name">
          <xsl:text>Relative Wind Direction</xsl:text>
        </xsl:element>
        <xsl:element name="parameter_data_field_position">
          <xsl:text>5</xsl:text>
        </xsl:element>
        <xsl:element name="is_series">
          <xsl:text>0</xsl:text>
        </xsl:element>
        <xsl:element name="is_compute_on_update">
          <xsl:text>1</xsl:text>
        </xsl:element>
        <xsl:element name="display_order">
          <xsl:text>2</xsl:text>
        </xsl:element>
        <xsl:element name="function_parameter_id">
          <xsl:text>15</xsl:text>
        </xsl:element>
        <xsl:element name="data_field_definition">
          <xsl:attribute name="data_field_def_id">
            <xsl:value-of select="../RWDirBaseDataFieldDef/DataFieldDefinition/@DataFieldDefID"/>
          </xsl:attribute>
        </xsl:element>
        <xsl:element name="units_type_name">
          <xsl:text>Other</xsl:text>
        </xsl:element>
        <xsl:element name="units_type_id">
          <xsl:text>32</xsl:text>
        </xsl:element>
      </xsl:element>
      <xsl:element name="calculation_parameter">
        <xsl:attribute name="calculation_parameter_id">
          <xsl:text>00000000-0000-0000-0000-000000000000</xsl:text>
        </xsl:attribute>
        <xsl:element name="parameter_name">
          <xsl:text>sog</xsl:text>
        </xsl:element>
        <xsl:element name="calculation_function_parameter.display_name">
          <xsl:text>SOG</xsl:text>
        </xsl:element>
        <xsl:element name="parameter_data_field_position">
          <xsl:text>1</xsl:text>
        </xsl:element>
        <xsl:element name="is_series">
          <xsl:text>0</xsl:text>
        </xsl:element>
        <xsl:element name="is_compute_on_update">
          <xsl:text>0</xsl:text>
        </xsl:element>
        <xsl:element name="display_order">
          <xsl:text>3</xsl:text>
        </xsl:element>
        <xsl:element name="function_parameter_id">
          <xsl:text>11</xsl:text>
        </xsl:element>
        <xsl:element name="data_field_definition">
          <xsl:attribute name="data_field_def_id">
            <xsl:value-of select="../SOGBaseDataFieldDef/DataFieldDefinition/@DataFieldDefID"/>
          </xsl:attribute>
        </xsl:element>
        <xsl:element name="units_type_name">
          <xsl:text>Other</xsl:text>
        </xsl:element>
        <xsl:element name="units_type_id">
          <xsl:text>32</xsl:text>
        </xsl:element>
      </xsl:element>
      <xsl:element name="calculation_parameter">
        <xsl:attribute name="calculation_parameter_id">
          <xsl:text>00000000-0000-0000-0000-000000000000</xsl:text>
        </xsl:attribute>
        <xsl:element name="parameter_name">
          <xsl:text>cog</xsl:text>
        </xsl:element>
        <xsl:element name="calculation_function_parameter.display_name">
          <xsl:text>COG</xsl:text>
        </xsl:element>
        <xsl:element name="parameter_data_field_position">
          <xsl:text>2</xsl:text>
        </xsl:element>
        <xsl:element name="is_series">
          <xsl:text>0</xsl:text>
        </xsl:element>
        <xsl:element name="is_compute_on_update">
          <xsl:text>0</xsl:text>
        </xsl:element>
        <xsl:element name="display_order">
          <xsl:text>4</xsl:text>
        </xsl:element>
        <xsl:element name="function_parameter_id">
          <xsl:text>12</xsl:text>
        </xsl:element>
        <xsl:element name="data_field_definition">
          <xsl:attribute name="data_field_def_id">
            <xsl:value-of select="../COGBaseDataFieldDef/DataFieldDefinition/@DataFieldDefID"/>
          </xsl:attribute>
        </xsl:element>
        <xsl:element name="units_type_name">
          <xsl:text>Other</xsl:text>
        </xsl:element>
        <xsl:element name="units_type_id">
          <xsl:text>32</xsl:text>
        </xsl:element>
      </xsl:element>
      <xsl:element name="calculation_parameter">
        <xsl:attribute name="calculation_parameter_id">
          <xsl:text>00000000-0000-0000-0000-000000000000</xsl:text>
        </xsl:attribute>
        <xsl:element name="parameter_name">
          <xsl:text>heading</xsl:text>
        </xsl:element>
        <xsl:element name="calculation_function_parameter.display_name">
          <xsl:text>Heading</xsl:text>
        </xsl:element>
        <xsl:element name="parameter_data_field_position">
          <xsl:text>3</xsl:text>
        </xsl:element>
        <xsl:element name="is_series">
          <xsl:text>0</xsl:text>
        </xsl:element>
        <xsl:element name="is_compute_on_update">
          <xsl:text>0</xsl:text>
        </xsl:element>
        <xsl:element name="display_order">
          <xsl:text>5</xsl:text>
        </xsl:element>
        <xsl:element name="function_parameter_id">
          <xsl:text>13</xsl:text>
        </xsl:element>
        <xsl:element name="data_field_definition">
          <xsl:attribute name="data_field_def_id">
            <xsl:value-of select="../GyroBaseDataFieldDef/DataFieldDefinition/@DataFieldDefID"/>
          </xsl:attribute>
        </xsl:element>
        <xsl:element name="units_type_name">
          <xsl:text>Other</xsl:text>
        </xsl:element>
        <xsl:element name="units_type_id">
          <xsl:text>32</xsl:text>
        </xsl:element>
      </xsl:element>
    </xsl:element>    
  </xsl:template>
  <xsl:template match="CalculatedTWSpeedDerivedDataFieldDef"/>
  <xsl:template match="COGBaseDataFieldDef"/>
  <xsl:template match="SOGBaseDataFieldDef"/>
  <xsl:template match="RWDirBaseDataFieldDef"/>
  <xsl:template match="RWSpeedBaseDataFieldDef"/>
  <xsl:template match="GyroBaseDataFieldDef"/>


  <!-- DataFieldDefinition -->
  <xsl:template match="DataFieldDefinition">
    <xsl:variable name="ddid" select= "@DataFieldDefID"/>
    <xsl:element name="data_field_definition">
      <xsl:attribute name="data_field_def_id">
	      <xsl:value-of select="$ddid"/>
      </xsl:attribute>
      <xsl:element name="name">
        <xsl:choose>
	        <xsl:when test="contains(name(..),'DerivedDataFieldDef')">
            <xsl:value-of select="DataFieldDefinitionName"/>
          </xsl:when>
          <xsl:when test="contains(name(..),'BaseDataFieldDef')">
            <xsl:value-of select="/DeviceConfiguration/SensorDevice/MessageDefinition/DataFieldDefinition[@DataFieldDefID=$ddid]/../MessageDefinitionName"/>-<xsl:value-of select="DataFieldDefinitionName"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="../MessageDefinitionName"/>-<xsl:value-of select="DataFieldDefinitionName"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
      <xsl:element name="data_field_type">
        <xsl:choose>
          <xsl:when test="contains(./DataFieldType,'Serial')">Fixed</xsl:when>
          <xsl:when test="./DataFieldType='NMEA'">Delimited</xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="./DataFieldType"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
      <xsl:element name="display_name">
        <xsl:value-of select="./DataFieldDefinitionName"/>
      </xsl:element>
      <xsl:element name="units">
        <xsl:text>Other</xsl:text>
      </xsl:element>
      <xsl:choose>
        <xsl:when test="./Units">
          <xsl:element name="other_units">
            <xsl:value-of select="./Units"/>
          </xsl:element>
        </xsl:when>
        <xsl:otherwise>
          <!-- No Units specified -->
          <xsl:element name="other_units">
            <xsl:text>Unknown</xsl:text>
          </xsl:element>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="./DataFieldType='Derived'">
          <xsl:element name="numeric_precision">
            <xsl:value-of select="./Precision"/>
          </xsl:element>
          <xsl:element name="calc_result_name">
            <xsl:value-of select="./DataFieldDefinitionName"/>
          </xsl:element>
        </xsl:when>
      </xsl:choose>
      <xsl:apply-templates/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="DataFieldType"/>
  <xsl:template match="DataFieldDefinitionName"/>
  <xsl:template match="Units"/>
  <xsl:template match="DecodeType"/>
  <xsl:template match="EligibleBaseDataFieldFlg">
    <xsl:element name="is_eligible_base_data_field">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="DataFieldCategory">
    <xsl:element name="data_field_category">
      <xsl:choose>
	      <xsl:when test=".='Other'">
          <xsl:choose>
	        <xsl:when test="starts-with(../DecodeType,'Real')">
            <xsl:text>Other -- Decimal</xsl:text>
          </xsl:when>
            <xsl:when test="starts-with(../DecodeType,'Int')">
            <xsl:text>Other -- Integer</xsl:text>
          </xsl:when>
          <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
        </xsl:choose>
        </xsl:when>
        <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
      </xsl:choose>
    </xsl:element>
    <xsl:element name="other_data_field_category">
      <xsl:choose>
        <xsl:when test=".='Other'">
          <xsl:text>Unknown</xsl:text>
        </xsl:when>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
  <xsl:template match="RangeCheckFlg"/>
  <xsl:template match="RangeLow"/>
  <xsl:template match="RangeHigh"/>
  <xsl:template match="DeltaCheckFlg"/>
  <xsl:template match="DeltaLow"/>
  <xsl:template match="DeltaHigh"/>
  <xsl:template match="IncludeInCompressFileFlg">
    <!-- Not including Include in Compress File in SCS5
    <xsl:element name="is_included_in_compress_file">
      <xsl:value-of select="."/>
    </xsl:element>-->
    <xsl:element name="is_included_as_ref_data_source_for_cat">
      <xsl:text>1</xsl:text>
    </xsl:element>
    <xsl:element name="reference_order_in_cat">
      <xsl:text>999</xsl:text>
    </xsl:element>
    <xsl:element name="is_excluded_from_samos">
      <xsl:text>0</xsl:text>
    </xsl:element>
  </xsl:template>
  
  <!-- DerivedDataFieldDef -->
  <xsl:template match="Precision"/>
  
  
  <!-- NMEADataFieldDef -->
  <xsl:template match="UnitsFieldPosition">
    <xsl:choose>
      <xsl:when test="../DataFieldCategory='Latitude'">
        <xsl:element name="latitude_format">
          <xsl:text>Degrees-Minutes</xsl:text>
        </xsl:element>
      </xsl:when>
      <xsl:when test="../DataFieldCategory='Longitude'">
        <xsl:element name="longitude_format">
          <xsl:text>Degrees-Minutes</xsl:text>
        </xsl:element>
      </xsl:when>
    </xsl:choose>
    <xsl:element name="lat_lon_direction_field_position">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="CodeTranslation">
    <xsl:element name="code_translation">
      <xsl:attribute name="code_translation_id">
        <xsl:text>00000000-0000-0000-0000-000000000000</xsl:text>
      </xsl:attribute>
      <xsl:element name="code_value">
        <xsl:value-of select="CodeValue"/>
      </xsl:element>
      <xsl:element name="translation">
        <xsl:value-of select="Translation"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  
  <!-- Serial and PolledSerial DataFieldDef -->
  <xsl:template match="StartCharPosition">
    <xsl:element name="start_char_position">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="EndCharPosition">
    <xsl:element name="end_char_position">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  
  <!-- PhysicalDevice -->
  <xsl:template match="PhysicalDevice">
    <xsl:element name="physical_device">
      <xsl:attribute name="physical_device_id">
	      <xsl:value-of select="@PhysicalDeviceID"/>
      </xsl:attribute>
      <xsl:element name="name">
        <xsl:choose>
          <xsl:when test="SerialNo">
            <xsl:choose>
              <xsl:when test="PhysicalDeviceType">
                <xsl:value-of select="PhysicalDeviceType"/>-<xsl:value-of select="SerialNo"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>Unknown-</xsl:text><xsl:value-of select="SerialNo"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <xsl:choose>
              <xsl:when test="PhysicalDeviceType">
                <xsl:value-of select="PhysicalDeviceType"/>-<xsl:value-of select="PhysicalDeviceName"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>Unknown-</xsl:text>
                <xsl:value-of select="PhysicalDeviceName"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
      <xsl:element name="physical_device_type">
        <xsl:text>Other</xsl:text>
      </xsl:element>
      <xsl:element name="other_physical_device_type">
        <xsl:choose>
          <xsl:when test="PhysicalDeviceType">
            <xsl:value-of select="PhysicalDeviceType"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>Unknown</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
      <xsl:apply-templates select="PhysicalDeviceName"/>
      <xsl:apply-templates select="Manufacturer"/>
      <xsl:apply-templates select="ModelNo"/>
      <xsl:apply-templates select="SerialNo"/>
      <xsl:apply-templates select="Comment"/>
      <xsl:apply-templates select="Location"/>
      <xsl:apply-templates select="DisplayOrder"/>
      <xsl:apply-templates select="NoCalibrationFlg"/>
      <xsl:apply-templates select="MeasRefSystem"/>
      <xsl:apply-templates select="XLocation"/>
      <xsl:apply-templates select="YLocation"/>
      <xsl:apply-templates select="ZLocation"/>
      <xsl:apply-templates select="CDNumber"/>
      <xsl:apply-templates select="IsExternal"/>
      <xsl:apply-templates select="DeviceCalibrationFile"/>
      <xsl:apply-templates select="CalibrationDate"/>
      <xsl:apply-templates select="DeviceTest"/>

      <xsl:call-template name="handleImages">
        <xsl:with-param name="from" select="1"/>
        <xsl:with-param name="to" select="count(DeviceImage)"/>
        <xsl:with-param name="physicalDeviceName" select="./PhysicalDeviceName"/>
      </xsl:call-template>

      <xsl:apply-templates select="PhysicalDevice"/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="PhysicalDeviceType"/>
  <xsl:template match="PhysicalDeviceName">
    <xsl:element name="display_name">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="Manufacturer">
    <xsl:element name="manufacturer">
      <xsl:text>Other</xsl:text>
    </xsl:element>
    <xsl:element name="other_manufacturer">
      <xsl:value-of select="."/>
    </xsl:element>
    <xsl:element name="model">
      <xsl:text>Other</xsl:text>
    </xsl:element>
    <xsl:element name="other_model">
      <xsl:choose>
        <xsl:when test="../ModelNo">
          <xsl:value-of select="../ModelNo"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>Unknown</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
  <xsl:template match="ModelNo"/>
  <xsl:template match="SerialNo">
    <xsl:element name="serial_no">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="Location">
    <xsl:element name="location">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="NoCalibrationFlg">
    <xsl:element name="is_no_calibration">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="MeasRefSystem">
    <xsl:element name="meas_ref_system">
      <xsl:value-of select="SystemName"/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="XLocation">
    <xsl:element name="x_location">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="YLocation">
    <xsl:element name="y_location">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="ZLocation">
    <xsl:element name="z_location">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="CDNumber">
    <xsl:element name="cd_number">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="DeviceCalibrationFile">
    <xsl:element name="calibration_file">
      <xsl:apply-templates select="./SCSFile"/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="IsExternal">
    <xsl:element name="is_external">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="CalibrationDate">
    <xsl:element name="physical_device_calibration">
      <xsl:attribute name="device_calibration_id">
        <xsl:text>00000000-0000-0000-0000-000000000000</xsl:text>
      </xsl:attribute>
      <xsl:element name="calibration_date">
        <xsl:value-of select="."/>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <xsl:template match="DeviceTest">
    <xsl:element name="physical_device_test">
      <xsl:attribute name="physical_device_test_id">
        <xsl:value-of select="@PhysicalDeviceTestID"/>
      </xsl:attribute>
      <xsl:element name="test_date">
        <xsl:value-of select="TestDate"/>
      </xsl:element>
      <xsl:element name="test_results">
        <xsl:value-of select="TestResults"/>
      </xsl:element>
      <xsl:element name="tester">
        <xsl:value-of select="Tester"/>
      </xsl:element>
      <xsl:apply-templates select="Comment"/>
    </xsl:element>
  </xsl:template>
  
  
  <!-- DeviceImages -->
  <xsl:template name="handleImages">
    <xsl:param name="from"/>
    <xsl:param name="to"/>
    <xsl:param name="physicalDeviceName"/>
    <xsl:if test="$from &lt;= $to">
      <xsl:element name="device_image">
        <xsl:attribute name="device_image_id">
          <xsl:value-of select="DeviceImage[$from]/@DeviceImageID"/>
        </xsl:attribute>
        <xsl:element name="name">
          <xsl:text>Image:  </xsl:text>
          <xsl:value-of select="$physicalDeviceName"/>
          <xsl:text> - Image </xsl:text>
          <xsl:value-of select="$from"/>
        </xsl:element>
        <xsl:element name="display_name">
          <xsl:value-of select="$physicalDeviceName"/>
          <xsl:text> - Image </xsl:text>
          <xsl:value-of select="$from"/>
        </xsl:element>
        <xsl:element name="display_order">
          <xsl:value-of select="$from"/>
        </xsl:element>
        <xsl:apply-templates select="DeviceImage[$from]/Comment"/>
        <xsl:apply-templates select="DeviceImage[$from]/SCSFile"/>
      </xsl:element>
      <xsl:call-template name="handleImages">
        <xsl:with-param name="from" select="$from + 1"/>
        <xsl:with-param name="to" select="$to"/>
        <xsl:with-param name="physicalDeviceName" select="$physicalDeviceName"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
  <xsl:template match="DeviceImage"/>



  <!-- DeviceInstallation -->
  <xsl:template match="DeviceInstallation">
    <xsl:element name="device_installation">
      <xsl:attribute name="device_installation_id">
        <xsl:value-of select="@DeviceInstallationID"/>
      </xsl:attribute>
      <xsl:apply-templates />
    </xsl:element>
  </xsl:template>
  <xsl:template match="PhysicalDeviceID">
    <xsl:element name="physical_device_id">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="InstallationDate">
    <xsl:element name="installation_date">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="RemovalDate">
    <xsl:element name="removal_date">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="Installer">
    <xsl:element name="installer">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>
  
</xsl:stylesheet>
